<?php
namespace model;

class Plays extends \Pawn\Model
{
	// Migration
	public static function migration()
	{
		return array
		(
			array('CREATE', array
			(
				'user_id'	=>	'INT UNSIGNED',
				'game_id'	=>	'INT UNSIGNED',
				'times'		=>	'INT UNSIGNED'
			))
		);
	}
	
	// Validation
	public function columns($preset)
	{
		return array
		(
			'user_id'	=>	array('text', array('c_user_exists'=>array($this, 'user_exists'))),
			'game_id'	=>	array('text', array('c_user_exists'=>array($this, 'game_exists'))),
			'times'		=>	array('text', array('positive_integer'=>true))
		);
	}
	
	public function user_exists($id)
	{
		return \model\User::num_rows('WHERE id=?', $id, false);
	}
	
	public function game_exists($id)
	{
		return \model\Game::num_rows('WHERE id=?', $id, false);
	}
}